import Utilities.waveform_creator as wc
import Utilities.gui_creator as gc
import Utilities.plot_creator as pc


def calculate_plot_waveform():
    
    num, samp_freq = gc.get_dig_entries(var_num,
                                        var_samp_freq)
    a, f, shape = gc.get_wav_entries(var_a, var_f,
                                     var_shape)

    t = wc.create_time_data(num, samp_freq)
    y = wc.create_waveform_data(t, a, f, shape)

    freq, complex_amp = wc.fft_complex(y, num, samp_freq)

    amp_real = complex_amp.real
    amp_imag = complex_amp.imag
    
    pc.update_plot(ax, canvas, freq, amp_real,
                   label_x, label_y, marker='o')
    
    pc.update_plot(ax, canvas, freq, amp_imag,
                   label_x, label_y, marker='-',
                   clear_flag=False)
                                        
    return


label_x, label_y = 'Frequency (Hz)', 'Complex-Amplitude'

root = gc.create_window(title='FFT of Sinusoids',
                         size= '1000x500')
control_box,right_frame = gc.create_frames(root)

var_num, var_samp_freq = gc.digitizing_control(control_box)
var_a, var_f,var_shape = gc.waveform_control(control_box)

ax, canvas = pc.create_plot(right_frame)
pc.update_plot(ax, canvas, [], [], label_x, label_y)

gc.action_button(control_box, label='Submit',
                 action=calculate_plot_waveform)

root.mainloop()
action=calculate_plot_waveform
gc.action_button(controls_box,label,action)

root.mainloop()
